<?php

require __DIR__.'/../../vendor/autoload.php';

use Gerencianet\Exception\GerencianetException;
use Gerencianet\Gerencianet;

$file = file_get_contents(__DIR__.'/../config.json');
$options = json_decode($file, true);

$items = [
  [
    'name' => 'Item 1',
    'amount' => 1,
    'value' => 1000
  ],
  [
    'name' => 'Item 2',
    'amount' => 2,
    'value' => 2000
  ] 
];

$customer = [
	'name' => 'Gorbadoc Oldbuck',
	'cpf' => '04267484171',
	'phone_number' => '5144916523'
];

$configurations = [ // configurações de juros e mora
  'fine' => 200, // porcentagem de multa
  'interest' => 33 // porcentagem de juros
];
$conditional_discount = [ // configurações de desconto condicional
  'type' => 'currency', // seleção do tipo de desconto 
  'value' => 500, // porcentagem de desconto
  'until_date' => '2020-02-15' // data máxima para aplicação do desconto
];
        

$body = [
  'items' => $items,
  'customer' => $customer,
  'expire_at' => '2020-02-20',
  'repeats' => 5,
  'split_items' => false,
  'configurations' => $configurations,
  'conditional_discount' => $conditional_discount
];
